define(['AbstractWeeklyGoalsService', 'WeeklyGoalsService', 'CollectionCRUDService', 'HomePageConstants', 'localResourceDirectoryService','connection_error_service', 'patient'], function() {
    'use strict';

    describe("Weekly Goals Service", function (){
        var weeklyGoalsService,
            focusServiceMock = jasmine.createSpy('focusService');

        beforeEach(function() {
            module('angularTemplateApp');

            module(function($provide){
                $provide.value('focusService', focusServiceMock);
            });

            inject(function(WeeklyGoalsService) {
                weeklyGoalsService = WeeklyGoalsService.instance();
            });
        });

        describe("when instantiated", function() {
            it("weekly goals should be defined correctly", function() {
                expect(weeklyGoalsService.config).toBeDefined();
                expect(weeklyGoalsService.config.dependency.service).toBeDefined();
                expect(weeklyGoalsService.config.collection.filter).toBeDefined();
                expect(weeklyGoalsService.config.object.uidKey).toBeDefined();
                expect(weeklyGoalsService.config.object.responseTransform).toBeDefined();
                expect(weeklyGoalsService.config.object.requestTransform).toBeDefined();
                expect(weeklyGoalsService.createEmpty).toBeDefined();
            });
        });

        describe("methods", function() {
            it("should transform the date in the response", function() {
                var item = {
					startDate: null
				};

                expect(weeklyGoalsService.config.object.responseTransform(item)).toEqual(item);

                item.startDate = "12/12/2015 01:01:01";

                expect(weeklyGoalsService.config.object.responseTransform(item)).toEqual({
					startDate: "12/12/2015"
                });
            });

            it("should transform the date in the request", function() {
                var item = {
						startDate: null
                    };

                expect(weeklyGoalsService.config.object.requestTransform(item)).toEqual(item);

                item.startDate = "12/12/2015";

                expect(weeklyGoalsService.config.object.requestTransform(item)).toEqual({
					startDate: "12/12/2015 00:00:00"
                });
            });

			it("should provide a filter", function() {
				var filters = {},
					listItem1 = { activeFlag: false },
					listItem2 = { activeFlag: true },
					listItem3 = { activeFlag: false },
					list = [listItem1, listItem2, listItem3];

				expect(weeklyGoalsService.config.collection.filter(list, filters)).toEqual([listItem1, listItem2, listItem3]);

				filters.activeFlag = true;
				expect(weeklyGoalsService.config.collection.filter(list, filters)).toEqual([listItem2]);

				filters.activeFlag = false;
				expect(weeklyGoalsService.config.collection.filter(list, filters)).toEqual([listItem1, listItem3]);

				filters = {unusedFilterProperty: true};
				expect(weeklyGoalsService.config.collection.filter(list, filters)).toEqual([listItem1, listItem2, listItem3]);
			});

            it("weekly goals should create an empty object", function() {
                var item = {
					activeFlag : false,
					startDate : null,
					target : {
						minutes : null,
						steps : null,
						miles : null
					}
				};

                expect(weeklyGoalsService.createEmpty()).toEqual(item);
            });
        });
    });
});